//
//  SCMessageRule.h
//  SweetCocoaAppKit
//
//  Created by Rico on 5/14/13.
//
//

#import <Foundation/Foundation.h>

enum SCMessageConditionOperation: NSInteger
{
    SCMessageConditionEquals       = 0,
    SCMessageConditionLessThan     = 1,
    SCMessageConditionGreaterThan  = 2,
    SCMessageConditionMatchesRegex = 3,
    SCMessageConditionIsNil        = 4
};

typedef NSInteger SCMessageConditionOperation;

@interface SCMessageCondition : NSObject

@property (strong) NSString *key;

@property SCMessageConditionOperation operation;

@property (strong) id rightOperand;

+ (SCMessageCondition*)conditionWithKey:(NSString*)key operation:(SCMessageConditionOperation)operation rightOperand:(id)rightOperand;

- (BOOL)appliesToLeftOperand:(id)leftOperand;

@end
